/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.colorSpaces;

import java.awt.Paint;
import java.util.List;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.contents.IContentContext;
import org.pdfclown.documents.contents.colorSpaces.Color;
import org.pdfclown.documents.contents.colorSpaces.ColorSpace;
import org.pdfclown.documents.contents.colorSpaces.Pattern;
import org.pdfclown.documents.contents.colorSpaces.SpecialColorSpace;
import org.pdfclown.documents.contents.colorSpaces.TilingPattern;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.util.NotImplementedException;

@PDF(value=VersionEnum.PDF12)
public final class PatternColorSpace
extends SpecialColorSpace<PdfDirectObject> {
    public static final PatternColorSpace Default = new PatternColorSpace(null);

    PatternColorSpace(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public Object clone(Document context) {
        throw new NotImplementedException();
    }

    @Override
    public Color<?> getColor(List<PdfDirectObject> components, IContentContext context) {
        TilingPattern tilingPattern;
        Pattern pattern = (Pattern)context.getResources().getPatterns().get(components.get(components.size() - 1));
        if (pattern instanceof TilingPattern && (tilingPattern = (TilingPattern)pattern).getPaintType() == TilingPattern.PaintTypeEnum.Uncolored) {
            ColorSpace<?> underlyingColorSpace = this.getUnderlyingColorSpace();
            if (underlyingColorSpace == null) {
                throw new IllegalArgumentException("Uncolored tiling patterns not supported by this color space because no underlying color space has been defined.");
            }
            Color<?> color = underlyingColorSpace.getColor(components, context);
            pattern = tilingPattern.colorize(color);
        }
        return pattern;
    }

    @Override
    public int getComponentCount() {
        return 0;
    }

    @Override
    public Pattern<?> getDefaultColor() {
        return Pattern.Default;
    }

    @Override
    public Paint getPaint(Color<?> color) {
        return null;
    }

    public ColorSpace<?> getUnderlyingColorSpace() {
        PdfArray baseArrayObject;
        PdfDirectObject baseDataObject = (PdfDirectObject)this.getBaseDataObject();
        if (baseDataObject instanceof PdfArray && (baseArrayObject = (PdfArray)baseDataObject).size() > 1) {
            return ColorSpace.wrap(baseArrayObject.get(1));
        }
        return null;
    }
}

