/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.colorSpaces;

import java.util.ArrayList;
import java.util.List;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.contents.colorSpaces.Color;
import org.pdfclown.documents.contents.colorSpaces.PatternColorSpace;
import org.pdfclown.documents.contents.colorSpaces.ShadingPattern;
import org.pdfclown.documents.contents.colorSpaces.TilingPattern;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfDataObject;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfInteger;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfNumber;
import org.pdfclown.objects.PdfStream;
import org.pdfclown.util.NotImplementedException;

@PDF(value=VersionEnum.PDF12)
public abstract class Pattern<TDataObject extends PdfDataObject>
extends Color<TDataObject> {
    public static final Pattern<?> Default = new TilingPattern(null);
    private static final int PatternType1 = 1;
    private static final int PatternType2 = 2;

    public static Pattern<?> wrap(PdfDirectObject baseObject) {
        if (baseObject == null) {
            return null;
        }
        PdfDataObject dataObject = baseObject.resolve();
        PdfDictionary dictionary = Pattern.getDictionary(dataObject);
        int patternType = (Integer)((PdfInteger)dictionary.get(PdfName.PatternType)).getRawValue();
        switch (patternType) {
            case 1: {
                return new TilingPattern(baseObject);
            }
            case 2: {
                return new ShadingPattern(baseObject);
            }
        }
        throw new UnsupportedOperationException("Pattern type " + patternType + " unknown.");
    }

    private static final PdfDictionary getDictionary(PdfDataObject patternDataObject) {
        if (patternDataObject instanceof PdfDictionary) {
            return (PdfDictionary)patternDataObject;
        }
        return ((PdfStream)patternDataObject).getHeader();
    }

    protected Pattern(PdfDirectObject baseObject) {
        super(baseObject);
    }

    protected Pattern(PatternColorSpace colorSpace, PdfDirectObject baseObject) {
        super(colorSpace, baseObject);
    }

    @Override
    public Object clone(Document context) {
        throw new NotImplementedException();
    }

    @Override
    public List<PdfDirectObject> getComponents() {
        return new ArrayList<PdfDirectObject>();
    }

    public double[] getMatrix() {
        PdfArray matrix = (PdfArray)this.getDictionary().get(PdfName.Matrix);
        if (matrix == null) {
            return new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
        }
        return new double[]{((PdfNumber)matrix.get(0)).getDoubleValue(), ((PdfNumber)matrix.get(1)).getDoubleValue(), ((PdfNumber)matrix.get(2)).getDoubleValue(), ((PdfNumber)matrix.get(3)).getDoubleValue(), ((PdfNumber)matrix.get(4)).getDoubleValue(), ((PdfNumber)matrix.get(5)).getDoubleValue()};
    }

    protected final PdfDictionary getDictionary() {
        return Pattern.getDictionary(this.getBaseDataObject());
    }
}

