/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.colorSpaces;

import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.contents.colorSpaces.DeviceColor;
import org.pdfclown.documents.contents.colorSpaces.DeviceRGBColorSpace;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfReal;
import org.pdfclown.util.NotImplementedException;

@PDF(value=VersionEnum.PDF11)
public final class DeviceRGBColor
extends DeviceColor {
    public static final DeviceRGBColor Black = DeviceRGBColor.get(Color.BLACK);
    public static final DeviceRGBColor White = DeviceRGBColor.get(Color.WHITE);
    public static final DeviceRGBColor Default = Black;

    public static DeviceRGBColor get(PdfArray components) {
        return components != null ? new DeviceRGBColor(components) : Default;
    }

    public static DeviceRGBColor get(Color color) {
        return color != null ? new DeviceRGBColor((double)color.getRed() / 255.0, (double)color.getGreen() / 255.0, (double)color.getBlue() / 255.0) : Default;
    }

    public DeviceRGBColor(double r, double g, double b) {
        this(Arrays.asList(PdfReal.get(DeviceRGBColor.normalizeComponent(r)), PdfReal.get(DeviceRGBColor.normalizeComponent(g)), PdfReal.get(DeviceRGBColor.normalizeComponent(b))));
    }

    DeviceRGBColor(List<? extends PdfDirectObject> components) {
        super(DeviceRGBColorSpace.Default, (PdfDirectObject)new PdfArray(components));
    }

    @Override
    public Object clone(Document context) {
        throw new NotImplementedException();
    }

    public double getB() {
        return this.getComponentValue(2);
    }

    public double getG() {
        return this.getComponentValue(1);
    }

    public double getR() {
        return this.getComponentValue(0);
    }

    public void setB(double value) {
        this.setComponentValue(2, value);
    }

    public void setG(double value) {
        this.setComponentValue(1, value);
    }

    public void setR(double value) {
        this.setComponentValue(0, value);
    }

    public static /* bridge */ /* synthetic */ DeviceColor get(PdfArray pdfArray) {
        return DeviceRGBColor.get(pdfArray);
    }
}

