/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents.colorSpaces;

import java.awt.Paint;
import java.util.List;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.contents.IContentContext;
import org.pdfclown.documents.contents.colorSpaces.CalGrayColorSpace;
import org.pdfclown.documents.contents.colorSpaces.CalRGBColorSpace;
import org.pdfclown.documents.contents.colorSpaces.Color;
import org.pdfclown.documents.contents.colorSpaces.DeviceCMYKColorSpace;
import org.pdfclown.documents.contents.colorSpaces.DeviceGrayColorSpace;
import org.pdfclown.documents.contents.colorSpaces.DeviceNColorSpace;
import org.pdfclown.documents.contents.colorSpaces.DeviceRGBColorSpace;
import org.pdfclown.documents.contents.colorSpaces.ICCBasedColorSpace;
import org.pdfclown.documents.contents.colorSpaces.IndexedColorSpace;
import org.pdfclown.documents.contents.colorSpaces.LabColorSpace;
import org.pdfclown.documents.contents.colorSpaces.PatternColorSpace;
import org.pdfclown.documents.contents.colorSpaces.SeparationColorSpace;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfDataObject;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfObjectWrapper;

public abstract class ColorSpace<TDataObject extends PdfDirectObject>
extends PdfObjectWrapper<TDataObject> {
    public static ColorSpace<?> wrap(PdfDirectObject baseObject) {
        if (baseObject == null) {
            return null;
        }
        PdfDataObject baseDataObject = baseObject.resolve();
        PdfName name = (PdfName)(baseDataObject instanceof PdfArray ? ((PdfArray)baseDataObject).get(0) : baseDataObject);
        if (name.equals(PdfName.DeviceRGB)) {
            return new DeviceRGBColorSpace(baseObject);
        }
        if (name.equals(PdfName.DeviceCMYK)) {
            return new DeviceCMYKColorSpace(baseObject);
        }
        if (name.equals(PdfName.DeviceGray)) {
            return new DeviceGrayColorSpace(baseObject);
        }
        if (name.equals(PdfName.CalRGB)) {
            return new CalRGBColorSpace(baseObject);
        }
        if (name.equals(PdfName.CalGray)) {
            return new CalGrayColorSpace(baseObject);
        }
        if (name.equals(PdfName.ICCBased)) {
            return new ICCBasedColorSpace(baseObject);
        }
        if (name.equals(PdfName.Lab)) {
            return new LabColorSpace(baseObject);
        }
        if (name.equals(PdfName.DeviceN)) {
            return new DeviceNColorSpace(baseObject);
        }
        if (name.equals(PdfName.Indexed)) {
            return new IndexedColorSpace(baseObject);
        }
        if (name.equals(PdfName.Pattern)) {
            return new PatternColorSpace(baseObject);
        }
        if (name.equals(PdfName.Separation)) {
            return new SeparationColorSpace(baseObject);
        }
        throw new UnsupportedOperationException("Color space " + name + " unknown.");
    }

    protected ColorSpace(Document context, TDataObject baseDataObject) {
        super(context, baseDataObject);
    }

    protected ColorSpace(PdfDirectObject baseObject) {
        super(baseObject);
    }

    public abstract Color<?> getColor(List<PdfDirectObject> var1, IContentContext var2);

    public abstract int getComponentCount();

    public abstract Color<?> getDefaultColor();

    public abstract Paint getPaint(Color<?> var1);
}

