/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents;

import java.util.HashMap;
import java.util.Map;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;

@PDF(value=VersionEnum.PDF10)
public enum LineJoinEnum {
    Miter(0),
    Round(1),
    Bevel(2);

    private static Map<Integer, LineJoinEnum> map;
    private final int code;

    static {
        map = new HashMap<Integer, LineJoinEnum>();
        LineJoinEnum[] lineJoinEnumArray = LineJoinEnum.values();
        int n = lineJoinEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            LineJoinEnum value = lineJoinEnumArray[n2];
            map.put(value.getCode(), value);
            ++n2;
        }
    }

    private LineJoinEnum(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public int toAwt() {
        switch (this) {
            case Bevel: {
                return 2;
            }
            case Miter: {
                return 0;
            }
            case Round: {
                return 1;
            }
        }
        throw new UnsupportedOperationException(String.valueOf(this.name()) + " convertion not supported.");
    }

    public static LineJoinEnum valueOf(String string) {
        return Enum.valueOf(LineJoinEnum.class, string);
    }
}

