/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown.documents.contents;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.pdfclown.documents.contents.BlendModeEnum;
import org.pdfclown.documents.contents.Contents;
import org.pdfclown.documents.contents.IContentContext;
import org.pdfclown.documents.contents.ITextString;
import org.pdfclown.documents.contents.LineCapEnum;
import org.pdfclown.documents.contents.LineDash;
import org.pdfclown.documents.contents.LineJoinEnum;
import org.pdfclown.documents.contents.RotationEnum;
import org.pdfclown.documents.contents.TextChar;
import org.pdfclown.documents.contents.TextRenderModeEnum;
import org.pdfclown.documents.contents.TextStyle;
import org.pdfclown.documents.contents.colorSpaces.Color;
import org.pdfclown.documents.contents.colorSpaces.ColorSpace;
import org.pdfclown.documents.contents.colorSpaces.DeviceGrayColor;
import org.pdfclown.documents.contents.colorSpaces.DeviceGrayColorSpace;
import org.pdfclown.documents.contents.fonts.Font;
import org.pdfclown.documents.contents.objects.CompositeObject;
import org.pdfclown.documents.contents.objects.ContainerObject;
import org.pdfclown.documents.contents.objects.ContentObject;
import org.pdfclown.documents.contents.objects.InlineImage;
import org.pdfclown.documents.contents.objects.ShowText;
import org.pdfclown.documents.contents.objects.Text;
import org.pdfclown.documents.contents.objects.XObject;
import org.pdfclown.documents.contents.xObjects.FormXObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.util.NotImplementedException;
import org.pdfclown.util.math.geom.Dimension;

public final class ContentScanner {
    private static final int StartIndex = -1;
    private ContentScanner childLevel;
    private Contents contents;
    private int index;
    private final List<ContentObject> objects;
    private final ContentScanner parentLevel;
    private GraphicsState state;
    private Graphics2D renderContext;
    private Shape renderObject;
    private Dimension2D renderSize;
    List<IListener> listeners = new ArrayList<IListener>();

    public ContentScanner(Contents contents) {
        this.parentLevel = null;
        this.objects = this.contents = contents;
        this.moveStart();
    }

    public ContentScanner(IContentContext contentContext) {
        this(contentContext.getContents());
    }

    public ContentScanner(final FormXObject formXObject, ContentScanner parentLevel) {
        this.parentLevel = parentLevel;
        this.objects = this.contents = formXObject.getContents();
        this.addListener(new IListener(){

            @Override
            public void onStart(ContentScanner scanner) {
                scanner.getState().getCtm().concatenate(formXObject.getMatrix());
            }
        });
        this.moveStart();
    }

    private ContentScanner(ContentScanner parentLevel) {
        this.parentLevel = parentLevel;
        this.contents = parentLevel.contents;
        this.objects = ((CompositeObject)parentLevel.getCurrent()).getObjects();
        this.moveStart();
    }

    public void addListener(IListener listener) {
        this.listeners.add(listener);
    }

    public Dimension2D getCanvasSize() {
        return this.renderSize == null ? Dimension.get(this.getContentContext().getBox()) : this.renderSize;
    }

    public ContentScanner getChildLevel() {
        return this.childLevel;
    }

    public IContentContext getContentContext() {
        return this.contents.getContentContext();
    }

    public Contents getContents() {
        return this.contents;
    }

    public ContentObject getCurrent() {
        if (this.index < 0 || this.index >= this.objects.size()) {
            return null;
        }
        return this.objects.get(this.index);
    }

    public GraphicsObjectWrapper<?> getCurrentWrapper() {
        return GraphicsObjectWrapper.get(this);
    }

    public int getIndex() {
        return this.index;
    }

    public CompositeObject getParent() {
        return this.parentLevel == null ? null : (CompositeObject)this.parentLevel.getCurrent();
    }

    public ContentScanner getParentLevel() {
        return this.parentLevel;
    }

    public Graphics2D getRenderContext() {
        return this.renderContext;
    }

    public Shape getRenderObject() {
        return this.renderObject;
    }

    public ContentScanner getRootLevel() {
        ContentScanner level = this;
        ContentScanner parentLevel;
        while ((parentLevel = level.getParentLevel()) != null) {
            level = parentLevel;
        }
        return level;
    }

    public GraphicsState getState() {
        return this.state;
    }

    public void insert(ContentObject object) {
        if (this.index == -1) {
            this.index = 0;
        }
        this.objects.add(this.index, object);
        this.refresh();
    }

    public void insert(Collection<? extends ContentObject> objects) {
        int index = 0;
        int size = objects.size();
        for (ContentObject contentObject : objects) {
            this.insert(contentObject);
            if (++index >= size) continue;
            this.moveNext();
        }
    }

    public boolean isRootLevel() {
        return this.parentLevel == null;
    }

    public boolean move(int index) {
        if (this.index > index) {
            this.moveStart();
        }
        while (this.index < index && this.moveNext()) {
        }
        return this.getCurrent() != null;
    }

    public void moveEnd() {
        this.moveLast();
        this.moveNext();
    }

    public boolean moveFirst() {
        this.moveStart();
        return this.moveNext();
    }

    public boolean moveLast() {
        int lastIndex = this.objects.size() - 1;
        while (this.index < lastIndex) {
            this.moveNext();
        }
        return this.getCurrent() != null;
    }

    public boolean moveNext() {
        ContentObject currentObject = this.getCurrent();
        if (currentObject != null) {
            currentObject.scan(this.state);
        }
        if (this.index < this.objects.size()) {
            ++this.index;
            this.refresh();
        }
        return this.getCurrent() != null;
    }

    public void moveStart() {
        this.index = -1;
        if (this.state == null) {
            this.state = this.parentLevel == null ? new GraphicsState(this) : this.parentLevel.state.clone(this);
        } else if (this.parentLevel == null) {
            this.state.initialize();
        } else {
            this.parentLevel.state.copyTo(this.state);
        }
        this.notifyStart();
        this.refresh();
    }

    public ContentObject remove() {
        ContentObject removedObject = this.objects.remove(this.index);
        this.refresh();
        return removedObject;
    }

    public boolean removeListener(IListener listener) {
        return this.listeners.remove(listener);
    }

    public void render(Graphics2D renderContext, Dimension2D renderSize) {
        this.render(renderContext, renderSize, null);
    }

    public void render(Graphics2D renderContext, Dimension2D renderSize, Shape renderObject) {
        if (this.isRootLevel()) {
            renderContext.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            renderContext.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            renderContext.setColor(java.awt.Color.WHITE);
            renderContext.fillRect(0, 0, (int)renderSize.getWidth(), (int)renderSize.getHeight());
        }
        try {
            this.renderContext = renderContext;
            this.renderSize = renderSize;
            this.renderObject = renderObject;
            this.moveStart();
            while (this.moveNext()) {
            }
        }
        finally {
            this.renderContext = null;
            this.renderSize = null;
            this.renderObject = null;
        }
    }

    public ContentObject setCurrent(ContentObject value) {
        ContentObject replacedObject = this.objects.set(this.index, value);
        this.refresh();
        return replacedObject;
    }

    protected void notifyStart() {
        for (IListener listener : this.listeners) {
            listener.onStart(this);
        }
    }

    private void refresh() {
        this.childLevel = this.getCurrent() instanceof CompositeObject ? new ContentScanner(this) : null;
    }

    public static abstract class GraphicsObjectWrapper<TDataObject extends ContentObject> {
        protected Rectangle2D box;
        private final TDataObject baseDataObject;

        private static GraphicsObjectWrapper<?> get(ContentScanner scanner) {
            ContentObject object = scanner.getCurrent();
            if (object instanceof ShowText) {
                return new TextStringWrapper(scanner);
            }
            if (object instanceof Text) {
                return new TextWrapper(scanner);
            }
            if (object instanceof XObject) {
                return new XObjectWrapper(scanner);
            }
            if (object instanceof InlineImage) {
                return new InlineImageWrapper(scanner);
            }
            return null;
        }

        protected GraphicsObjectWrapper(TDataObject baseDataObject) {
            this.baseDataObject = baseDataObject;
        }

        public TDataObject getBaseDataObject() {
            return this.baseDataObject;
        }

        public Rectangle2D getBox() {
            return this.box;
        }
    }

    public static final class GraphicsState
    implements Cloneable {
        private List<BlendModeEnum> blendMode;
        private double charSpace;
        private AffineTransform ctm;
        private Color<?> fillColor;
        private ColorSpace<?> fillColorSpace;
        private Font font;
        private double fontSize;
        private double lead;
        private LineCapEnum lineCap;
        private LineDash lineDash;
        private LineJoinEnum lineJoin;
        private double lineWidth;
        private double miterLimit;
        private TextRenderModeEnum renderMode;
        private double rise;
        private double scale;
        private Color<?> strokeColor;
        private ColorSpace<?> strokeColorSpace;
        private AffineTransform tlm;
        private AffineTransform tm;
        private double wordSpace;
        private ContentScanner scanner;

        private GraphicsState(ContentScanner scanner) {
            this.scanner = scanner;
            this.initialize();
        }

        public GraphicsState clone() {
            GraphicsState clone;
            try {
                clone = (GraphicsState)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
            clone.ctm = (AffineTransform)this.ctm.clone();
            clone.tlm = (AffineTransform)this.tlm.clone();
            clone.tm = (AffineTransform)this.tm.clone();
            return clone;
        }

        public void copyTo(GraphicsState state) {
            state.blendMode = this.blendMode;
            state.charSpace = this.charSpace;
            state.ctm = (AffineTransform)this.ctm.clone();
            state.fillColor = this.fillColor;
            state.fillColorSpace = this.fillColorSpace;
            state.font = this.font;
            state.fontSize = this.fontSize;
            state.lead = this.lead;
            state.lineCap = this.lineCap;
            state.lineDash = this.lineDash;
            state.lineJoin = this.lineJoin;
            state.lineWidth = this.lineWidth;
            state.miterLimit = this.miterLimit;
            state.renderMode = this.renderMode;
            state.rise = this.rise;
            state.scale = this.scale;
            state.strokeColor = this.strokeColor;
            state.strokeColorSpace = this.strokeColorSpace;
            if (state.scanner.getParent() instanceof Text) {
                state.tlm = (AffineTransform)this.tlm.clone();
                state.tm = (AffineTransform)this.tm.clone();
            } else {
                state.tlm = new AffineTransform();
                state.tm = new AffineTransform();
            }
            state.wordSpace = this.wordSpace;
        }

        public List<BlendModeEnum> getBlendMode() {
            return this.blendMode;
        }

        public double getCharSpace() {
            return this.charSpace;
        }

        public AffineTransform getCtm() {
            return this.ctm;
        }

        public Color<?> getFillColor() {
            return this.fillColor;
        }

        public ColorSpace<?> getFillColorSpace() {
            return this.fillColorSpace;
        }

        public Font getFont() {
            return this.font;
        }

        public double getFontSize() {
            return this.fontSize;
        }

        public AffineTransform getInitialCtm() {
            AffineTransform initialCtm;
            if (this.getScanner().getRenderContext() == null) {
                initialCtm = new AffineTransform();
            } else {
                IContentContext contentContext = this.getScanner().getContentContext();
                Dimension2D canvasSize = this.getScanner().getCanvasSize();
                RotationEnum rotation = contentContext.getRotation();
                switch (rotation) {
                    case Downward: {
                        initialCtm = new AffineTransform(1.0, 0.0, 0.0, -1.0, 0.0, canvasSize.getHeight());
                        break;
                    }
                    case Leftward: {
                        initialCtm = new AffineTransform(0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f);
                        break;
                    }
                    case Upward: {
                        initialCtm = new AffineTransform(-1.0, 0.0, 0.0, 1.0, canvasSize.getWidth(), 0.0);
                        break;
                    }
                    case Rightward: {
                        initialCtm = new AffineTransform(0.0, -1.0, -1.0, 0.0, canvasSize.getWidth(), canvasSize.getHeight());
                        break;
                    }
                    default: {
                        throw new NotImplementedException();
                    }
                }
                Rectangle2D contentBox = contentContext.getBox();
                Dimension2D rotatedCanvasSize = rotation.transform(canvasSize);
                initialCtm.scale(rotatedCanvasSize.getWidth() / contentBox.getWidth(), rotatedCanvasSize.getHeight() / contentBox.getHeight());
                initialCtm.translate(-contentBox.getMinX(), -contentBox.getMinY());
            }
            return initialCtm;
        }

        public double getLead() {
            return this.lead;
        }

        public LineCapEnum getLineCap() {
            return this.lineCap;
        }

        public LineDash getLineDash() {
            return this.lineDash;
        }

        public LineJoinEnum getLineJoin() {
            return this.lineJoin;
        }

        public double getLineWidth() {
            return this.lineWidth;
        }

        public double getMiterLimit() {
            return this.miterLimit;
        }

        public TextRenderModeEnum getRenderMode() {
            return this.renderMode;
        }

        public double getRise() {
            return this.rise;
        }

        public double getScale() {
            return this.scale;
        }

        public ContentScanner getScanner() {
            return this.scanner;
        }

        public Color<?> getStrokeColor() {
            return this.strokeColor;
        }

        public ColorSpace<?> getStrokeColorSpace() {
            return this.strokeColorSpace;
        }

        public AffineTransform getTlm() {
            return this.tlm;
        }

        public AffineTransform getTm() {
            return this.tm;
        }

        public double getWordSpace() {
            return this.wordSpace;
        }

        public void setBlendMode(List<BlendModeEnum> value) {
            this.blendMode = value;
        }

        public void setCharSpace(double value) {
            this.charSpace = value;
        }

        public void setCtm(AffineTransform value) {
            this.ctm = value;
        }

        public void setFillColor(Color<?> value) {
            this.fillColor = value;
        }

        public void setFillColorSpace(ColorSpace<?> value) {
            this.fillColorSpace = value;
        }

        public void setFont(Font value) {
            this.font = value;
        }

        public void setFontSize(double value) {
            this.fontSize = value;
        }

        public void setLead(double value) {
            this.lead = value;
        }

        public void setLineCap(LineCapEnum value) {
            this.lineCap = value;
        }

        public void setLineDash(LineDash value) {
            this.lineDash = value;
        }

        public void setLineJoin(LineJoinEnum value) {
            this.lineJoin = value;
        }

        public void setLineWidth(double value) {
            this.lineWidth = value;
        }

        public void setMiterLimit(double value) {
            this.miterLimit = value;
        }

        public void setRenderMode(TextRenderModeEnum value) {
            this.renderMode = value;
        }

        public void setRise(double value) {
            this.rise = value;
        }

        public void setScale(double value) {
            this.scale = value;
        }

        public void setStrokeColor(Color<?> value) {
            this.strokeColor = value;
        }

        public void setStrokeColorSpace(ColorSpace<?> value) {
            this.strokeColorSpace = value;
        }

        public void setTlm(AffineTransform value) {
            this.tlm = value;
        }

        public void setTm(AffineTransform value) {
            this.tm = value;
        }

        public void setWordSpace(double value) {
            this.wordSpace = value;
        }

        public Point2D textToDeviceSpace(Point2D point) {
            return this.textToDeviceSpace(point, false);
        }

        public Point2D textToDeviceSpace(Point2D point, boolean topDown) {
            AffineTransform trm = topDown ? new AffineTransform(1.0, 0.0, 0.0, -1.0, 0.0, this.scanner.getCanvasSize().getHeight()) : new AffineTransform();
            trm.concatenate(this.ctm);
            trm.concatenate(this.tm);
            return trm.transform(point, null);
        }

        public Point2D userToDeviceSpace(Point2D point) {
            return this.ctm.transform(point, null);
        }

        private GraphicsState clone(ContentScanner scanner) {
            GraphicsState state = this.clone();
            state.scanner = scanner;
            return state;
        }

        private void initialize() {
            this.blendMode = Collections.emptyList();
            this.charSpace = 0.0;
            this.ctm = this.getInitialCtm();
            this.fillColor = DeviceGrayColor.Default;
            this.fillColorSpace = DeviceGrayColorSpace.Default;
            this.font = null;
            this.fontSize = 0.0;
            this.lead = 0.0;
            this.lineCap = LineCapEnum.Butt;
            this.lineDash = new LineDash();
            this.lineJoin = LineJoinEnum.Miter;
            this.lineWidth = 1.0;
            this.miterLimit = 10.0;
            this.renderMode = TextRenderModeEnum.Fill;
            this.rise = 0.0;
            this.scale = 100.0;
            this.strokeColor = DeviceGrayColor.Default;
            this.strokeColorSpace = DeviceGrayColorSpace.Default;
            this.tlm = new AffineTransform();
            this.tm = new AffineTransform();
            this.wordSpace = 0.0;
            Graphics2D renderContext = this.getScanner().getRenderContext();
            if (renderContext != null) {
                renderContext.setTransform(this.ctm);
            }
        }
    }

    public static interface IListener {
        public void onStart(ContentScanner var1);
    }

    public static final class InlineImageWrapper
    extends GraphicsObjectWrapper<InlineImage> {
        private InlineImageWrapper(ContentScanner scanner) {
            super((InlineImage)scanner.getCurrent());
            AffineTransform ctm = scanner.getState().getCtm();
            this.box = new Rectangle2D.Double(ctm.getTranslateX(), scanner.getContentContext().getBox().getHeight() - ctm.getTranslateY(), ctm.getScaleX(), Math.abs(ctm.getScaleY()));
        }

        public InlineImage getInlineImage() {
            return (InlineImage)this.getBaseDataObject();
        }
    }

    public static final class TextStringWrapper
    extends GraphicsObjectWrapper<ShowText>
    implements ITextString {
        private TextStyle style;
        private final List<TextChar> textChars = new ArrayList<TextChar>();

        TextStringWrapper(ContentScanner scanner) {
            super((ShowText)scanner.getCurrent());
            GraphicsState state = scanner.getState();
            this.style = new TextStyle(state.getFont(), state.getFontSize() * state.getTm().getScaleY(), state.getRenderMode(), state.getStrokeColor(), state.getStrokeColorSpace(), state.getFillColor(), state.getFillColorSpace());
            ((ShowText)this.getBaseDataObject()).scan(state, new ShowText.IScanner(){

                @Override
                public void scanChar(char textChar, Rectangle2D textCharBox) {
                    TextStringWrapper.this.textChars.add(new TextChar(textChar, textCharBox, TextStringWrapper.this.style, false));
                }
            });
        }

        @Override
        public Rectangle2D getBox() {
            if (this.box == null) {
                for (TextChar textChar : this.textChars) {
                    if (this.box == null) {
                        this.box = (Rectangle2D)textChar.getBox().clone();
                        continue;
                    }
                    this.box.add(textChar.getBox());
                }
            }
            return this.box;
        }

        public TextStyle getStyle() {
            return this.style;
        }

        @Override
        public String getText() {
            StringBuilder textBuilder = new StringBuilder();
            for (TextChar textChar : this.textChars) {
                textBuilder.append(textChar);
            }
            return textBuilder.toString();
        }

        @Override
        public List<TextChar> getTextChars() {
            return this.textChars;
        }
    }

    public static final class TextWrapper
    extends GraphicsObjectWrapper<Text> {
        private final List<TextStringWrapper> textStrings = new ArrayList<TextStringWrapper>();

        private TextWrapper(ContentScanner scanner) {
            super((Text)scanner.getCurrent());
            this.extract(scanner.getChildLevel());
        }

        @Override
        public Rectangle2D getBox() {
            if (this.box == null) {
                for (TextStringWrapper textString : this.textStrings) {
                    if (this.box == null) {
                        this.box = (Rectangle2D)textString.getBox().clone();
                        continue;
                    }
                    this.box.add(textString.getBox());
                }
            }
            return this.box;
        }

        public List<TextStringWrapper> getTextStrings() {
            return this.textStrings;
        }

        /*
         * Unable to fully structure code
         */
        private void extract(ContentScanner level) {
            if (level != null) ** GOTO lbl10
            return;
lbl-1000:
            // 1 sources

            {
                content = level.getCurrent();
                if (content instanceof ShowText) {
                    this.textStrings.add((TextStringWrapper)level.getCurrentWrapper());
                    continue;
                }
                if (!(content instanceof ContainerObject)) continue;
                this.extract(level.getChildLevel());
lbl10:
                // 4 sources

                ** while (level.moveNext())
            }
lbl11:
            // 1 sources

        }
    }

    public static final class XObjectWrapper
    extends GraphicsObjectWrapper<XObject> {
        private final PdfName name;
        private final org.pdfclown.documents.contents.xObjects.XObject xObject;

        private XObjectWrapper(ContentScanner scanner) {
            super((XObject)scanner.getCurrent());
            IContentContext context = scanner.getContentContext();
            AffineTransform ctm = scanner.getState().getCtm();
            this.box = new Rectangle2D.Double(ctm.getTranslateX(), context.getBox().getHeight() - ctm.getTranslateY(), ctm.getScaleX(), Math.abs(ctm.getScaleY()));
            this.name = ((XObject)this.getBaseDataObject()).getName();
            this.xObject = ((XObject)this.getBaseDataObject()).getResource(context);
        }

        public PdfName getName() {
            return this.name;
        }

        public org.pdfclown.documents.contents.xObjects.XObject getXObject() {
            return this.xObject;
        }
    }
}

