/*
 * Decompiled with CFR 0.152.
 */
package org.pdfclown;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pdfclown.objects.PdfName;
import org.pdfclown.util.metadata.IVersion;
import org.pdfclown.util.metadata.VersionUtils;

public final class Version
implements IVersion {
    private static final Pattern versionPattern = Pattern.compile("^(\\d+)\\.(\\d+)$");
    private static final Map<String, Version> versions = new HashMap<String, Version>();
    private final int major;
    private final int minor;

    public static Version get(PdfName version) {
        return Version.get((String)version.getRawValue());
    }

    public static Version get(String version) {
        if (!versions.containsKey(version)) {
            Matcher versionMatcher = versionPattern.matcher(version);
            if (!versionMatcher.find()) {
                throw new RuntimeException("Invalid PDF version format: '" + versionPattern + "' pattern expected.");
            }
            Version versionObject = new Version(Integer.valueOf(versionMatcher.group(1)), Integer.valueOf(versionMatcher.group(2)));
            versions.put(version, versionObject);
        }
        return versions.get(version);
    }

    private Version(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    @Override
    public List<Integer> getNumbers() {
        return Arrays.asList(this.major, this.minor);
    }

    public String toString() {
        return VersionUtils.toString(this);
    }

    @Override
    public int compareTo(IVersion value) {
        return VersionUtils.compareTo(this, value);
    }
}

