/*
 * Decompiled with CFR 0.152.
 */
package highlight;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.pdfclown.PDF;
import org.pdfclown.VersionEnum;
import org.pdfclown.documents.Document;
import org.pdfclown.documents.Page;
import org.pdfclown.documents.contents.BlendModeEnum;
import org.pdfclown.documents.contents.ExtGState;
import org.pdfclown.documents.contents.ExtGStateResources;
import org.pdfclown.documents.contents.LineCapEnum;
import org.pdfclown.documents.contents.LineJoinEnum;
import org.pdfclown.documents.contents.colorSpaces.DeviceRGBColor;
import org.pdfclown.documents.contents.composition.PrimitiveComposer;
import org.pdfclown.documents.contents.xObjects.FormXObject;
import org.pdfclown.documents.interaction.annotations.Annotation;
import org.pdfclown.documents.interaction.annotations.AppearanceStates;
import org.pdfclown.objects.PdfArray;
import org.pdfclown.objects.PdfDictionary;
import org.pdfclown.objects.PdfDirectObject;
import org.pdfclown.objects.PdfName;
import org.pdfclown.objects.PdfNumber;
import org.pdfclown.objects.PdfReal;
import org.pdfclown.objects.PdfStream;
import org.pdfclown.objects.Rectangle;
import org.pdfclown.util.NotImplementedException;
import org.pdfclown.util.math.geom.Quad;

@PDF(value=VersionEnum.PDF13)
public final class TextMarkupNew
extends Annotation {
    private static final PdfName HighlightExtGStateName = new PdfName("highlight");

    private static double getMarkupBoxMargin(double boxHeight) {
        return boxHeight * 0.25;
    }

    public TextMarkupNew(Page page, String text, MarkupTypeEnum markupType, Quad markupBox) {
        this(page, text, markupType, Arrays.asList(markupBox));
    }

    public TextMarkupNew(Page page, String text, MarkupTypeEnum markupType, List<Quad> markupBoxes) {
        super(page, markupType.getCode(), markupBoxes.get(0).getBounds2D(), text);
        this.setMarkupType(markupType);
        this.setMarkupBoxes(markupBoxes);
        this.setPrintable(true);
    }

    public TextMarkupNew(Page page, String text, MarkupTypeEnum markupType, List<Quad> markupBoxes, DeviceRGBColor color) {
        super(page, markupType.getCode(), markupBoxes.get(0).getBounds2D(), text);
        this.setMarkupType(markupType, color);
        this.setMarkupBoxes(markupBoxes);
        this.setPrintable(true);
    }

    TextMarkupNew(PdfDirectObject baseObject) {
        super(baseObject);
    }

    @Override
    public TextMarkupNew clone(Document context) {
        return (TextMarkupNew)super.clone(context);
    }

    public List<Quad> getMarkupBoxes() {
        ArrayList<Quad> markupBoxes = new ArrayList<Quad>();
        PdfArray quadPointsObject = (PdfArray)((PdfDictionary)this.getBaseDataObject()).get(PdfName.QuadPoints);
        if (quadPointsObject != null) {
            double pageHeight = this.getPage().getBox().getHeight();
            int index = 0;
            int length = quadPointsObject.size();
            while (index < length) {
                markupBoxes.add(new Quad(new Point2D.Double(((PdfNumber)quadPointsObject.get(index)).getDoubleValue(), pageHeight - ((PdfNumber)quadPointsObject.get(index + 1)).getDoubleValue()), new Point2D.Double(((PdfNumber)quadPointsObject.get(index + 2)).getDoubleValue(), pageHeight - ((PdfNumber)quadPointsObject.get(index + 3)).getDoubleValue()), new Point2D.Double(((PdfNumber)quadPointsObject.get(index + 6)).getDoubleValue(), pageHeight - ((PdfNumber)quadPointsObject.get(index + 7)).getDoubleValue()), new Point2D.Double(((PdfNumber)quadPointsObject.get(index + 4)).getDoubleValue(), pageHeight - ((PdfNumber)quadPointsObject.get(index + 5)).getDoubleValue())));
                index += 8;
            }
        }
        return markupBoxes;
    }

    public MarkupTypeEnum getMarkupType() {
        return MarkupTypeEnum.get((PdfName)((PdfDictionary)this.getBaseDataObject()).get(PdfName.Subtype));
    }

    public void setMarkupBoxes(List<Quad> value) {
        PdfArray quadPointsObject = new PdfArray();
        double pageHeight = this.getPage().getBox().getHeight();
        RectangularShape box = null;
        for (Quad markupBox : value) {
            Point2D[] markupBoxPoints = markupBox.getPoints();
            quadPointsObject.add(PdfReal.get(markupBoxPoints[0].getX()));
            quadPointsObject.add(PdfReal.get(pageHeight - markupBoxPoints[0].getY()));
            quadPointsObject.add(PdfReal.get(markupBoxPoints[1].getX()));
            quadPointsObject.add(PdfReal.get(pageHeight - markupBoxPoints[1].getY()));
            quadPointsObject.add(PdfReal.get(markupBoxPoints[3].getX()));
            quadPointsObject.add(PdfReal.get(pageHeight - markupBoxPoints[3].getY()));
            quadPointsObject.add(PdfReal.get(markupBoxPoints[2].getX()));
            quadPointsObject.add(PdfReal.get(pageHeight - markupBoxPoints[2].getY()));
            if (box == null) {
                box = markupBox.getBounds2D();
                continue;
            }
            ((Rectangle2D)box).add(markupBox.getBounds2D());
        }
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.QuadPoints, quadPointsObject);
        double markupBoxMargin = TextMarkupNew.getMarkupBoxMargin(box.getHeight());
        ((Rectangle2D)box).setRect(box.getX() - markupBoxMargin, box.getY(), box.getWidth() + markupBoxMargin * 2.0, box.getHeight());
        this.setBox((Rectangle2D)box);
        this.refreshAppearance();
    }

    public void setMarkupType(MarkupTypeEnum value) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Subtype, value.getCode());
        switch (value) {
            case Highlight: {
                this.setColor(new DeviceRGBColor(1.0, 0.5, 1.0));
                break;
            }
            case Squiggly: {
                this.setColor(new DeviceRGBColor(1.0, 0.0, 0.0));
                break;
            }
            default: {
                this.setColor(new DeviceRGBColor(0.0, 0.0, 0.0));
            }
        }
        this.refreshAppearance();
    }

    private void setMarkupType(MarkupTypeEnum value, DeviceRGBColor color) {
        ((PdfDictionary)this.getBaseDataObject()).put(PdfName.Subtype, value.getCode());
        switch (value) {
            case Highlight: {
                this.setColor(color);
                break;
            }
            case Squiggly: {
                this.setColor(new DeviceRGBColor(1.0, 0.0, 0.0));
                break;
            }
            default: {
                this.setColor(new DeviceRGBColor(0.0, 0.0, 0.0));
            }
        }
        this.refreshAppearance();
    }

    private void refreshAppearance() {
        Rectangle2D box = Rectangle.wrap(((PdfDictionary)this.getBaseDataObject()).get(PdfName.Rect)).toRectangle2D();
        AppearanceStates normalAppearances = this.getAppearance().getNormal();
        FormXObject normalAppearance = normalAppearances.get(null);
        if (normalAppearance != null) {
            normalAppearance.setBox(box);
            ((PdfStream)normalAppearance.getBaseDataObject()).getBody().setLength(0);
        } else {
            normalAppearance = new FormXObject(this.getDocument(), box);
            normalAppearances.put(null, normalAppearance);
        }
        PrimitiveComposer composer = new PrimitiveComposer(normalAppearance);
        double yOffset = box.getHeight() - this.getPage().getBox().getHeight();
        MarkupTypeEnum markupType = this.getMarkupType();
        switch (markupType) {
            case Highlight: {
                ExtGStateResources extGStates = normalAppearance.getResources().getExtGStates();
                ExtGState defaultExtGState = (ExtGState)extGStates.get(HighlightExtGStateName);
                if (defaultExtGState == null) {
                    if (!extGStates.isEmpty()) {
                        extGStates.clear();
                    }
                    defaultExtGState = new ExtGState(this.getDocument());
                    extGStates.put(HighlightExtGStateName, defaultExtGState);
                    defaultExtGState.setAlphaShape(false);
                    defaultExtGState.setBlendMode(Arrays.asList(BlendModeEnum.Multiply));
                }
                composer.applyState(defaultExtGState);
                composer.setFillColor(this.getColor());
                for (Quad markupBox : this.getMarkupBoxes()) {
                    Point2D[] points = markupBox.getPoints();
                    double markupBoxHeight = points[3].getY() - points[0].getY();
                    double markupBoxMargin = TextMarkupNew.getMarkupBoxMargin(markupBoxHeight);
                    composer.drawCurve(new Point2D.Double(points[3].getX(), points[3].getY() + yOffset), new Point2D.Double(points[0].getX(), points[0].getY() + yOffset), new Point2D.Double(points[3].getX() - markupBoxMargin, points[3].getY() - markupBoxMargin + yOffset), new Point2D.Double(points[0].getX() - markupBoxMargin, points[0].getY() + markupBoxMargin + yOffset));
                    composer.drawLine(new Point2D.Double(points[1].getX(), points[1].getY() + yOffset));
                    composer.drawCurve(new Point2D.Double(points[2].getX(), points[2].getY() + yOffset), new Point2D.Double(points[1].getX() + markupBoxMargin, points[1].getY() + markupBoxMargin + yOffset), new Point2D.Double(points[2].getX() + markupBoxMargin, points[2].getY() - markupBoxMargin + yOffset));
                    composer.fill();
                }
                break;
            }
            case Squiggly: {
                composer.setStrokeColor(this.getColor());
                composer.setLineCap(LineCapEnum.Round);
                composer.setLineJoin(LineJoinEnum.Round);
                for (Quad markupBox : this.getMarkupBoxes()) {
                    Point2D[] points = markupBox.getPoints();
                    double markupBoxHeight = points[3].getY() - points[0].getY();
                    double lineWidth = markupBoxHeight * 0.02;
                    double step = markupBoxHeight * 0.125;
                    double boxXOffset = points[3].getX();
                    double boxYOffset = points[3].getY() + yOffset - lineWidth;
                    boolean phase = false;
                    composer.setLineWidth(lineWidth);
                    double x = 0.0;
                    double xEnd = points[2].getX() - boxXOffset;
                    while (x < xEnd || !phase) {
                        Point2D.Double point = new Point2D.Double(x + boxXOffset, (phase ? -step : 0.0) + boxYOffset);
                        if (x == 0.0) {
                            composer.startPath(point);
                        } else {
                            composer.drawLine(point);
                        }
                        phase = !phase;
                        x += step;
                    }
                }
                composer.stroke();
                break;
            }
            case StrikeOut: 
            case Underline: {
                double lineYRatio;
                composer.setStrokeColor(this.getColor());
                switch (markupType) {
                    case StrikeOut: {
                        lineYRatio = 0.575;
                        break;
                    }
                    case Underline: {
                        lineYRatio = 0.85;
                        break;
                    }
                    default: {
                        throw new NotImplementedException();
                    }
                }
                for (Quad markupBox : this.getMarkupBoxes()) {
                    Point2D[] points = markupBox.getPoints();
                    double markupBoxHeight = points[3].getY() - points[0].getY();
                    double boxYOffset = markupBoxHeight * lineYRatio + yOffset;
                    composer.setLineWidth(markupBoxHeight * 0.065);
                    composer.drawLine(new Point2D.Double(points[3].getX(), points[0].getY() + boxYOffset), new Point2D.Double(points[2].getX(), points[1].getY() + boxYOffset));
                }
                composer.stroke();
                break;
            }
            default: {
                throw new NotImplementedException();
            }
        }
        composer.flush();
    }

    public static enum MarkupTypeEnum {
        Highlight(PdfName.Highlight),
        Squiggly(PdfName.Squiggly),
        StrikeOut(PdfName.StrikeOut),
        Underline(PdfName.Underline);

        private final PdfName code;

        public static MarkupTypeEnum get(PdfName value) {
            MarkupTypeEnum[] markupTypeEnumArray = MarkupTypeEnum.values();
            int n = markupTypeEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                MarkupTypeEnum markupType = markupTypeEnumArray[n2];
                if (markupType.getCode().equals(value)) {
                    return markupType;
                }
                ++n2;
            }
            return null;
        }

        private MarkupTypeEnum(PdfName code) {
            this.code = code;
        }

        public PdfName getCode() {
            return this.code;
        }
    }
}

