/*
 * Decompiled with CFR 0.152.
 */
package highlight;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.util.LinkedList;

public class BlockLayout
implements LayoutManager2,
Serializable {
    private static final long serialVersionUID = -8696604975858663470L;
    int vgap;
    int padding_top;
    int padding_right;
    int padding_bottom;
    int padding_left;
    int align;
    public static final int ALIGN_CENTER = 0;
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int ALIGN_JUSTIFY = 3;
    public static final int ALIGN_INHERIT = -1;
    private LinkedList components;

    public BlockLayout() {
        this(0);
    }

    public BlockLayout(int align_default) {
        this(align_default, 0);
    }

    public BlockLayout(int align_default, int vgap) {
        this(align_default, vgap, 0);
    }

    public BlockLayout(int align_default, int vgap, int padding) {
        this(align_default, vgap, padding, padding, padding, padding);
    }

    public BlockLayout(int align_default, int vgap, int ptop, int pright, int pbottom, int pleft) {
        this.setAlign(align_default);
        this.setVgap(vgap);
        this.setPadding(ptop, pright, pbottom, pleft);
        this.components = new LinkedList();
    }

    public void setPadding(int ptop, int pright, int pbottom, int pleft) {
        this.padding_top = ptop;
        this.padding_right = pright;
        this.padding_bottom = pbottom;
        this.padding_left = pleft;
    }

    public int getAlign() {
        return this.align;
    }

    public int getPadding_top() {
        return this.padding_top;
    }

    public int getPadding_right() {
        return this.padding_right;
    }

    public int getPadding_bottom() {
        return this.padding_bottom;
    }

    public int getPadding_left() {
        return this.padding_left;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setAlign(int align) {
        this.align = align;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (constraints == null) {
                this.components.add(new BlockLayoutElement(comp, new BlockLayoutConstraints(-1)));
            } else if (constraints instanceof BlockLayoutConstraints) {
                this.components.add(new BlockLayoutElement(comp, (BlockLayoutConstraints)constraints));
            } else {
                throw new IllegalArgumentException("cannot add to layout: constraint must be a BlockLayoutConstraints (or null)");
            }
        }
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(String name, Component comp) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            int align = -1;
            if ("Left".equalsIgnoreCase(name)) {
                align = 1;
            } else if ("Right".equalsIgnoreCase(name)) {
                align = 2;
            } else if ("Center".equalsIgnoreCase(name)) {
                align = 0;
            } else if ("Justify".equalsIgnoreCase(name)) {
                align = 3;
            }
            this.addLayoutComponent(comp, new BlockLayoutConstraints(align));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            int top = insets.top + this.padding_top;
            int left = insets.left + this.padding_left;
            int right = target.getWidth() - insets.right - this.padding_right;
            int i = 0;
            while (i < this.components.size()) {
                Dimension d;
                BlockLayoutElement item = (BlockLayoutElement)this.components.get(i);
                Component comp = item.comp;
                int align = this.align;
                if (item.constr.align == 1 || item.constr.align == 0 || item.constr.align == 2 || item.constr.align == 3) {
                    align = item.constr.align;
                }
                top += item.constr.margin_top;
                int inner_left = left + item.constr.margin_left;
                int inner_right = right - item.constr.margin_right;
                int comp_height = comp.getPreferredSize().height;
                int comp_width = comp.getPreferredSize().width;
                if (align == 1) {
                    comp.setSize(comp_width, comp_height);
                    d = comp.getPreferredSize();
                    comp.setBounds(inner_left, top, comp_width, d.height);
                } else if (align == 2) {
                    comp.setSize(comp_width, comp_height);
                    d = comp.getPreferredSize();
                    comp.setBounds(inner_right - comp_width, top, comp_width, d.height);
                } else if (align == 3) {
                    comp.setSize(inner_right - inner_left, comp_height);
                    d = comp.getPreferredSize();
                    comp.setBounds(inner_left, top, inner_right - inner_left, d.height);
                } else {
                    comp.setSize(comp_width, comp_height);
                    d = comp.getPreferredSize();
                    comp.setBounds((inner_right - inner_left - comp_width) / 2, top, comp_width, d.height);
                }
                top += comp.getHeight() + item.constr.margin_bottom + this.vgap;
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            if (!this.components.isEmpty()) {
                dim.height += this.padding_top + this.padding_bottom;
                dim.height -= this.vgap;
            }
            int i = 0;
            while (i < this.components.size()) {
                BlockLayoutElement item = (BlockLayoutElement)this.components.get(i);
                dim.height += item.comp.getMinimumSize().height + this.vgap + item.constr.margin_top + item.constr.margin_bottom;
                dim.width = Math.max(dim.width, item.comp.getMinimumSize().width + this.padding_left + this.padding_right + item.constr.margin_left + item.constr.margin_right);
                ++i;
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            if (!this.components.isEmpty()) {
                dim.height += this.padding_top + this.padding_bottom;
                dim.height -= this.vgap;
            }
            int i = 0;
            while (i < this.components.size()) {
                BlockLayoutElement item = (BlockLayoutElement)this.components.get(i);
                dim.height += item.comp.getPreferredSize().height + this.vgap + item.constr.margin_top + item.constr.margin_bottom;
                dim.width = Math.max(dim.width, item.comp.getPreferredSize().width + this.padding_left + this.padding_right + item.constr.margin_left + item.constr.margin_right);
                ++i;
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLayoutComponent(Component comp) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            int i = 0;
            while (i < this.components.size()) {
                BlockLayoutElement item = (BlockLayoutElement)this.components.get(i);
                if (item.comp == comp) {
                    this.components.remove(i);
                    --i;
                }
                ++i;
            }
        }
    }

    public static class BlockLayoutConstraints {
        public int align;
        public int margin_left;
        public int margin_right;
        public int margin_top;
        public int margin_bottom;

        public BlockLayoutConstraints() {
            this(-1);
        }

        public BlockLayoutConstraints(int align) {
            this(align, 0, 0, 0, 0);
        }

        public BlockLayoutConstraints(int align, int margin) {
            this(align, margin, margin, margin, margin);
        }

        public BlockLayoutConstraints(int align, int margin_top, int margin_right, int margin_bottom, int margin_left) {
            this.align = align;
            this.setMargin(margin_top, margin_right, margin_bottom, margin_left);
        }

        public int getAlign() {
            return this.align;
        }

        public void setAlign(int align) {
            this.align = align;
        }

        public int getMargin_bottom() {
            return this.margin_bottom;
        }

        public int getMargin_left() {
            return this.margin_left;
        }

        public int getMargin_right() {
            return this.margin_right;
        }

        public int getMargin_top() {
            return this.margin_top;
        }

        public void setMargin(int margin_top, int margin_right, int margin_bottom, int margin_left) {
            this.margin_top = margin_top;
            this.margin_right = margin_right;
            this.margin_bottom = margin_bottom;
            this.margin_left = margin_left;
        }
    }

    private static class BlockLayoutElement {
        Component comp;
        BlockLayoutConstraints constr;

        BlockLayoutElement(Component comp, BlockLayoutConstraints constraints) {
            this.comp = comp;
            this.constr = constraints;
        }
    }
}

